Ext.data.JsonP.sol_common_DateUtils({"tagname":"class","name":"sol.common.DateUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.DateUtils.js","href":"lib_sol.common.DateUtils.html#sol-common-DateUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"aliases":{},"alternateClassNames":["sol.Date"],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"ISO_CONFIGS","tagname":"property","owner":"sol.common.DateUtils","id":"property-ISO_CONFIGS","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"dateToIso","tagname":"method","owner":"sol.common.DateUtils","id":"method-dateToIso","meta":{}},{"name":"diff","tagname":"method","owner":"sol.common.DateUtils","id":"method-diff","meta":{}},{"name":"endOf","tagname":"method","owner":"sol.common.DateUtils","id":"method-endOf","meta":{}},{"name":"format","tagname":"method","owner":"sol.common.DateUtils","id":"method-format","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isBetween","tagname":"method","owner":"sol.common.DateUtils","id":"method-isBetween","meta":{}},{"name":"isoToDate","tagname":"method","owner":"sol.common.DateUtils","id":"method-isoToDate","meta":{}},{"name":"nowIso","tagname":"method","owner":"sol.common.DateUtils","id":"method-nowIso","meta":{}},{"name":"parse","tagname":"method","owner":"sol.common.DateUtils","id":"method-parse","meta":{}},{"name":"prepareDuration","tagname":"method","owner":"sol.common.DateUtils","id":"method-prepareDuration","meta":{}},{"name":"shift","tagname":"method","owner":"sol.common.DateUtils","id":"method-shift","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.DateUtils","short_doc":"Utils for handling dates. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>sol.Date</div><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.DateUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils' target='_blank'>lib_sol.common.DateUtils.js</a></div></pre><div class='doc-contents'><p>Utils for handling dates. This allows e.g. converting ELO ISO dates to moment.js date-objects.</p>\n\n<p>Uses moment.js for converting and handling date strings. Please refer to the official documentation of\nmoment.js for further information. http://momentjs.com/docs/</p>\n\n<pre><code>var momentDate = <a href=\"#!/api/sol.common.DateUtils-method-isoToDate\" rel=\"sol.common.DateUtils-method-isoToDate\" class=\"docClass\">sol.common.DateUtils.isoToDate</a>('20151203');\n\n// add 7 days with moment.js\nvar oneWeekAfter = momentDate.add(7, 'days');\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-ISO_CONFIGS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-property-ISO_CONFIGS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-property-ISO_CONFIGS' class='name expandable'>ISO_CONFIGS</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Internal date formats used for checking and parsing ...</div><div class='long'><p>Internal date formats used for checking and parsing</p>\n<p>Defaults to: <code>{ISODATE: {format: &quot;YYYYMMDD&quot;, regex: /^\\d{8}$/}, ISODATETIME: {format: &quot;YYYYMMDDHHmmss&quot;, regex: /^\\d{14}$/}, ELOTSTAMP: {format: &quot;YYYY.MM.DD.HH.mm.ss&quot;, regex: /^\\d{4}(.\\d{2}){5}$/}, ISODATEMILLISECONDS: {format: &quot;YYYYMMDDHHmmssSSS&quot;, regex: /^\\d{17}$/}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-dateToIso' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-dateToIso' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-dateToIso' class='name expandable'>dateToIso</a>( <span class='pre'>date, [params]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Converts a date object to an iso string ...</div><div class='long'><p>Converts a date object to an iso string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : Date<div class='sub-desc'><p>The date object</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>withoutTime</span> : Boolean (optional)<div class='sub-desc'><p>If set to <code>true</code>, the time will be omitted from the ISO string</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>startOfDay</span> : Boolean (optional)<div class='sub-desc'><p>Start of day</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>utcOffset</span> : Boolean<div class='sub-desc'><p>UTC offset</p>\n<p>Defaults to: <code>(optional)</code></p></div></li><li><span class='pre'>pattern</span> : Boolean<div class='sub-desc'><p>Pattern</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The resulting iso date</p>\n</div></li></ul></div></div></div><div id='method-diff' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-diff' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-diff' class='name expandable'>diff</a>( <span class='pre'>startDate, endDate, unit, config</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates a difference between to dates ...</div><div class='long'><p>Calculates a difference between to dates</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startDate</span> : Date<div class='sub-desc'><p>Start date</p>\n</div></li><li><span class='pre'>endDate</span> : Date<div class='sub-desc'><p>End date</p>\n</div></li><li><span class='pre'>unit</span> : String<div class='sub-desc'><p>Unit</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>roundUp</span> : Boolean<div class='sub-desc'><p>Round up</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-endOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-endOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-endOf' class='name expandable'>endOf</a>( <span class='pre'>moment, unit</span> ) : Moment<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the end of time of a specified period ...</div><div class='long'><p>Returns the <code>end of</code> time of a specified period</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>moment</span> : Moment<div class='sub-desc'><p>Moment</p>\n</div></li><li><span class='pre'>unit</span> : String<div class='sub-desc'><p>Unit</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Moment</span><div class='sub-desc'><p>Moment</p>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-format' class='name expandable'>format</a>( <span class='pre'>date, pattern</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Formats a Date object. ...</div><div class='long'><p>Formats a Date object.</p>\n\n<pre><code> <a href=\"#!/api/sol.common.DateUtils-method-format\" rel=\"sol.common.DateUtils-method-format\" class=\"docClass\">sol.common.DateUtils.format</a>(new Date(), \"YYYY.MM.DD HH:mm:ss.SSS\")\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : Date<div class='sub-desc'><p>The date object</p>\n</div></li><li><span class='pre'>pattern</span> : String<div class='sub-desc'><p>Format string (see <a href=\"http://momentjs.com/\">moment.js</a> for formating options)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-isBetween' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-isBetween' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-isBetween' class='name expandable'>isBetween</a>( <span class='pre'>[startDate], [endDate], [checkDate]</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a date is between a start date and an end end date ...</div><div class='long'><p>Checks wether a date is between a start date and an end end date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startDate</span> : Date (optional)<div class='sub-desc'><p>Start date</p>\n<p>Defaults to: <code>now</code></p></div></li><li><span class='pre'>endDate</span> : Date (optional)<div class='sub-desc'><p>End date</p>\n<p>Defaults to: <code>now</code></p></div></li><li><span class='pre'>checkDate</span> : Date (optional)<div class='sub-desc'><p>Check date</p>\n<p>Defaults to: <code>now</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isoToDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-isoToDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-isoToDate' class='name expandable'>isoToDate</a>( <span class='pre'>isoDate, config</span> ) : Date<span class=\"signature\"></span></div><div class='description'><div class='short'>Converts an iso date string to a date object ...</div><div class='long'><p>Converts an iso date string to a date object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDate</span> : String<div class='sub-desc'><p>The iso date string</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>startOfDay</span> : Boolean<div class='sub-desc'><p>Return the start of the day</p>\n</div></li><li><span class='pre'>endOfDay</span> : Boolean<div class='sub-desc'><p>Return the end of the day</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Date</span><div class='sub-desc'><p>A JavaScript Date object</p>\n</div></li></ul></div></div></div><div id='method-nowIso' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-nowIso' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-nowIso' class='name expandable'>nowIso</a>( <span class='pre'>params, utcOffset</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns now as iso string ...</div><div class='long'><p>Returns now as iso string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n</div></li><li><span class='pre'>utcOffset</span> : String<div class='sub-desc'><p>UTC offset</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-parse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-parse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-parse' class='name expandable'>parse</a>( <span class='pre'>dateString, [pattern]</span> ) : Date<span class=\"signature\"></span></div><div class='description'><div class='short'>Parses a date string with a given pattern. ...</div><div class='long'><p>Parses a date string with a given pattern.</p>\n\n<pre><code>var maythefourth = <a href=\"#!/api/sol.common.DateUtils-method-parse\" rel=\"sol.common.DateUtils-method-parse\" class=\"docClass\">sol.common.DateUtils.parse</a>(\"1977-05-04\");\n\nvar maythefourth = <a href=\"#!/api/sol.common.DateUtils-method-parse\" rel=\"sol.common.DateUtils-method-parse\" class=\"docClass\">sol.common.DateUtils.parse</a>(\"04.05.1977\", \"DD.MM.YYYY\");\n\nvar maythefourth = <a href=\"#!/api/sol.common.DateUtils-method-parse\" rel=\"sol.common.DateUtils-method-parse\" class=\"docClass\">sol.common.DateUtils.parse</a>(\"05/04/1977\", \"MM/DD/YYYY\");\n</code></pre>\n\n<p>If no <code>pattern</code> is defined the function tries to figure out the format by using various standards (see <a href=\"https://momentjs.com/docs/#/parsing/string/\">moment.js/parsing</a>).\nFor consistent results the use of <code>pattern</code> is encouraged.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dateString</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>pattern</span> : String (optional)<div class='sub-desc'><p>Parse string (see <a href=\"http://momentjs.com/\">moment.js</a> for parsing options)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Date</span><div class='sub-desc'><p>Returns <code>null</code> if date could not be determined</p>\n</div></li></ul></div></div></div><div id='method-prepareDuration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-prepareDuration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-prepareDuration' class='name expandable'>prepareDuration</a>( <span class='pre'>number, unit</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Prepare duration ...</div><div class='long'><p>Prepare duration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>number</span> : Number<div class='sub-desc'><p>Duration</p>\n</div></li><li><span class='pre'>unit</span> : String<div class='sub-desc'><p>Duration unit</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Duration</p>\n</div></li></ul></div></div></div><div id='method-shift' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.DateUtils'>sol.common.DateUtils</span><br/><a href='source/lib_sol.common.DateUtils.html#sol-common-DateUtils-method-shift' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.DateUtils-method-shift' class='name expandable'>shift</a>( <span class='pre'>date, value, [params]</span> ) : Date|String<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds or removes time units from a date object. ...</div><div class='long'><p>Adds or removes time units from a date object.</p>\n\n<p>The following example will substracts 3 days from myDate and returns a Date</p>\n\n<pre><code><a href=\"#!/api/sol.common.DateUtils-method-shift\" rel=\"sol.common.DateUtils-method-shift\" class=\"docClass\">sol.common.DateUtils.shift</a>(myDate, -3)\n</code></pre>\n\n<p>The following example will adds 7 hours to myDate and returns a String with the specified pattern:</p>\n\n<pre><code><a href=\"#!/api/sol.common.DateUtils-method-shift\" rel=\"sol.common.DateUtils-method-shift\" class=\"docClass\">sol.common.DateUtils.shift</a>(myDate, 7, { pattern: \"YYYY.MM.DD HH:mm:ss\", unit: \"h\" })\n</code></pre>\n\n<p>Supported <code>unit</code> patterns:</p>\n\n<ul>\n<li>years: y</li>\n<li>half years: hy</li>\n<li>quarters: Q</li>\n<li>months: M</li>\n<li>weeks: w</li>\n<li>days: d</li>\n<li>hours: h</li>\n<li>minutes: m</li>\n<li>seconds: s</li>\n<li>milliseconds: ms</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : Date<div class='sub-desc'><p>The date object which should be used as base for the shift</p>\n</div></li><li><span class='pre'>value</span> : Number<div class='sub-desc'><p>The amount which should be shifted</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>Additional parameters</p>\n<ul><li><span class='pre'>pattern</span> : String (optional)<div class='sub-desc'><p>Format string (see <a href=\"http://momentjs.com/\">moment.js</a> for formating options)</p>\n</div></li><li><span class='pre'>unit</span> : String (optional)<div class='sub-desc'><p>The unit which should be added/substracted</p>\n<p>Defaults to: <code>&quot;d&quot;</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Date|String</span><div class='sub-desc'><p>Returns a <code>String</code> if a params.pattern is defined and a <code>Date</code> if not.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"singleton":true}});